/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Scanner;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

class Memory {
    static Highlighter hilit = new DefaultHighlighter();
    static Highlighter.HighlightPainter painterRed = new DefaultHighlighter.DefaultHighlightPainter(Color.red);
    static Highlighter.HighlightPainter painterChng = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 170, 170));
    static Highlighter.HighlightPainter painterPrev = new DefaultHighlighter.DefaultHighlightPainter(new Color(170, 255, 170));
    static Highlighter.HighlightPainter painterNext = new DefaultHighlighter.DefaultHighlightPainter(new Color(170, 170, 255));
    private Computer comp;
    private int columnsToDisplay = 16;
    private int wordSize = 8;
    private int startAddress = 0;
    private int[] ram;
    public int changed = -1;
    public int PCold = -1;
    public int PCnew = -1;
    private int start = 0;
    private int end = 0;
    private String name;
    public boolean skipUpdate = false;
    JTextArea jta;
    Object highlightChange;
    Object highlightPrev;
    Object highlightNext;
    int rowSize = this.columnsToDisplay * (this.wordSize / 4 + 1) + (this.columnsToDisplay > 1 ? 2 : 0) + 1;

    public Memory(int ps, int nw, JTextArea pjta, Computer pcomp) {
        this.comp = pcomp;
        this.wordSize = ps;
        this.ram = new int[nw];
        this.rowSize = this.columnsToDisplay * (this.wordSize / 4 + 1) + (this.columnsToDisplay > 1 ? 2 : 0) + 1;
        this.jta = pjta;
        this.jta.setHighlighter(hilit);
    }

    public Memory(int ps, int nw, int sa, JTextArea pjta, Computer pcomp) {
        this.comp = pcomp;
        this.wordSize = ps;
        this.ram = new int[nw];
        this.startAddress = sa;
        this.rowSize = this.columnsToDisplay * (this.wordSize / 4 + 1) + (this.columnsToDisplay > 1 ? 2 : 0) + 1;
        this.jta = pjta;
        this.jta.setHighlighter(hilit);
    }

    public Memory(String[] ta, JTextArea pjta, Computer pcomp) {
        this.comp = pcomp;
        this.jta = pjta;
        this.jta.setHighlighter(hilit);
        for (String t : ta) {
            Scanner st = new Scanner(t);
            while (st.hasNext()) {
                String label = st.next();
                if (label.equals("name")) {
                    this.name = st.next();
                }
                if (label.equals("start")) {
                    this.startAddress = st.nextInt(16);
                }
                if (!label.equals("size")) continue;
                this.ram = new int[st.nextInt()];
                this.wordSize = st.nextInt();
            }
        }
        this.rowSize = this.columnsToDisplay * (this.wordSize / 4 + 1) + (this.columnsToDisplay > 1 ? 2 : 0) + 1;
    }

    public boolean clearMemory() {
        this.changed = -1;
        for (int i = 0; i < this.ram.length; ++i) {
            this.ram[i] = 0;
        }
        return true;
    }

    private Object setRange(int i, Object h, Highlighter.HighlightPainter hp, String st) {
        try {
            if (i == -1) {
                return null;
            }
            if (h != null) {
                hilit.removeHighlight(h);
            }
            this.start = i % this.columnsToDisplay * (this.wordSize / 4 + 1) + this.rowSize * (i / this.columnsToDisplay) + 1;
            if (i % this.columnsToDisplay >= (this.columnsToDisplay + 1) / 2) {
                this.start += 2;
            }
            this.end = this.start + this.wordSize / 4;
            if (st != null) {
                this.jta.replaceRange(st, this.start, this.end);
            }
            return hilit.addHighlight(this.start, this.end, hp);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void updatePCHighlights() {
        if (this.jta.getText().length() == 0) {
            return;
        }
        this.highlightPrev = this.setRange(this.PCold, this.highlightPrev, painterPrev, null);
        this.highlightNext = this.setRange(this.PCnew, this.highlightNext, painterNext, null);
    }

    public boolean setMemory(int i, int v) {
        this.ram[i - this.startAddress] = v & ALUOperation.mask[this.wordSize];
        this.changed = i;
        if (this.skipUpdate) {
            return true;
        }
        if (this.jta.getText().length() == 0) {
            return true;
        }
        this.highlightChange = this.setRange(i, this.highlightChange, painterChng, String.format("%0" + this.wordSize / 4 + "x", v));
        return true;
    }

    public int getMemory(int i) {
        return this.ram[i - this.startAddress];
    }

    public void setColumns(int x, JTextArea jta) {
        this.columnsToDisplay = x;
        jta.setText(this.toAddrString());
        this.rowSize = this.columnsToDisplay * (this.wordSize / 4 + 1) + (this.columnsToDisplay > 1 ? 2 : 0) + 1;
    }

    public String toAddrString() {
        String st = String.format("%4x:", this.startAddress);
        for (int i = this.startAddress + 1; i < this.ram.length + this.startAddress; ++i) {
            if (i % this.columnsToDisplay != 0) continue;
            st = st + String.format("\n%4x:", i);
        }
        return st;
    }

    public String toString() {
        String st = "";
        for (int i = this.startAddress; i < this.ram.length + this.startAddress; ++i) {
            if (i > 0) {
                if (i % this.columnsToDisplay == 0) {
                    st = st + String.format("\n", new Object[0]);
                } else if (i % (this.columnsToDisplay / 2) == 0) {
                    st = st + "  ";
                }
            }
            st = st + String.format(" %0" + this.wordSize / 4 + "x", this.ram[i - this.startAddress]);
        }
        return st;
    }
}

