/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.JOptionPane;

class Instruction {
    private Computer comp;
    private ArrayList<Instruction> instructionSet;
    private ArrayList<Instruction> nextList = new ArrayList();
    private ArrayList<Instruction> fromList = new ArrayList();
    private int tick = -1;
    int index = 0;
    private boolean haltFlag = false;
    private boolean initialInstructionFlag = false;
    private boolean showConnectionsFlag = true;
    private ArrayList<Condition> conditionList = new ArrayList();
    private ArrayList<ALUOperation> ops = new ArrayList();

    public Instruction(Computer pcomp, String s) {
        ArrayList r;
        this.comp = pcomp;
        this.instructionSet = r = this.comp.instructionSet;
        Scanner str = new Scanner(s);
        str.useDelimiter(",");
        this.index = Integer.parseInt(str.next().trim());
        block9: while (str.hasNext()) {
            String token = str.next().trim();
            if (token.length() == 0) continue;
            switch (token.charAt(0)) {
                case 's': {
                    this.initialInstructionFlag = true;
                    continue block9;
                }
                case 'h': {
                    this.haltFlag = true;
                    continue block9;
                }
                case 'f': {
                    this.linkFrom(Integer.parseInt(token.substring(1).trim()));
                    continue block9;
                }
                case 't': {
                    this.tick = Integer.parseInt(token.substring(1).trim());
                    continue block9;
                }
                case 'n': {
                    this.linkTo(Integer.parseInt(token.substring(1).trim()));
                    continue block9;
                }
                case 'c': {
                    this.processCondition(token);
                    continue block9;
                }
                case '/': {
                    continue block9;
                }
            }
            ALUOperation a = this.processALUopToken(token);
            if (a == null) continue;
            this.ops.add(a);
        }
    }

    public boolean getHaltFlag() {
        return this.haltFlag;
    }

    public boolean isInitialInstruction() {
        return this.initialInstructionFlag;
    }

    public Instruction execute() {
        if (this.haltFlag) {
            return null;
        }
        for (ALUOperation op : this.ops) {
            op.doOp();
        }
        Instruction next = null;
        block1: for (Instruction n : this.nextList) {
            for (Condition c : n.conditionList) {
                if (c.testCondition()) continue;
                continue block1;
            }
            next = n;
            break;
        }
        return next;
    }

    private boolean linkFrom(int t) {
        for (Instruction i : this.instructionSet) {
            if (i.index != t) continue;
            i.nextList.add(this);
            this.fromList.add(i);
            return true;
        }
        return false;
    }

    private boolean linkTo(int t) {
        for (Instruction i : this.instructionSet) {
            if (i.index != t) continue;
            this.nextList.add(i);
            return true;
        }
        return false;
    }

    private boolean processCondition(String s) {
        this.conditionList.add(new Condition(this.comp, s));
        return true;
    }

    private ALUOperation processALUopToken(String s) {
        ALUOperation a = null;
        String[] t = s.split("[\\s]+");
        if (t.length < 2) {
            return null;
        }
        if (s.indexOf("<") >= 0) {
            if (t.length < 3) {
                return null;
            }
            try {
                a = this.memoryInstruction(t);
                if (a != null) {
                    return a;
                }
                Class<?> cc = Class.forName(t[3]);
                Class[] pt = new Class[]{this.comp.getClass().getInterfaces()[0], t.getClass()};
                Constructor<?> ctr = cc.getConstructor(pt);
                a = (ALUOperation)ctr.newInstance(this.comp, t);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "processALUopToken Exception: " + e + " on line: " + s);
            }
        } else {
            if (t[1].equals("++")) {
                a = new ALU_Increment(this.comp.getRegisterByName(t[0]));
                return a;
            }
            try {
                int v = Integer.parseInt(t[1], 16);
                a = new ALU_Set(v, this.comp.getRegisterByName(t[0]));
                return a;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "processALUopToken Exception: \n-- Number format exception: " + e + " on line: " + s);
            }
        }
        return a;
    }

    private ALUOperation memoryInstruction(String[] t) {
        ALU_RegisterMove a = new ALU_RegisterMove(this.comp, t);
        if (a.notOK) {
            return null;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.index);
        if (this.initialInstructionFlag) {
            sb.append(", s");
        }
        if (this.haltFlag) {
            sb.append(", h");
        }
        sb.append(", t " + this.tick);
        for (Condition cd : this.conditionList) {
            sb.append("," + cd + " Value: " + cd.testCondition());
        }
        if (this.showConnectionsFlag) {
            sb.append("\n");
            for (Instruction i : this.fromList) {
                sb.append(", f " + i.index);
            }
            for (Instruction i : this.nextList) {
                sb.append(", n " + i.index);
            }
        }
        for (ALUOperation a : this.ops) {
            sb.append(", " + a);
        }
        return sb.toString();
    }
}

