/*
 * Decompiled with CFR 0.152.
 */
class Condition {
    private RegisterFunctions r1 = null;
    private int value = 0;
    private int startBit = -1;
    private int endBit = -1;
    private ConditionCase cc = ConditionCase.EQ;

    public Condition(Computer comp, String s) {
        int index = 1;
        String[] t = s.split("[\\s]+");
        this.r1 = comp.getRegisterByName(t[index++]);
        if (Character.isDigit(t[index].charAt(0))) {
            this.startBit = Integer.parseInt(t[index++]);
            if (Character.isDigit(t[index].charAt(0))) {
                this.endBit = Integer.parseInt(t[index++]);
                if (this.endBit < this.startBit) {
                    int tm = this.endBit;
                    this.endBit = this.startBit;
                    this.startBit = tm;
                }
            }
        }
        if (t[index].equals("==")) {
            this.cc = ConditionCase.EQ;
        }
        if (t[index].equals("!=")) {
            this.cc = ConditionCase.NE;
        }
        if (t[index].equals("EQ")) {
            this.cc = ConditionCase.EQ;
        }
        if (t[index].equals("NE")) {
            this.cc = ConditionCase.NE;
        }
        if (t[index].equals("GT")) {
            this.cc = ConditionCase.GT;
        }
        if (t[index].equals("GE")) {
            this.cc = ConditionCase.GE;
        }
        if (t[index].equals("LT")) {
            this.cc = ConditionCase.LT;
        }
        if (t[index].equals("LE")) {
            this.cc = ConditionCase.LE;
        }
        this.value = t[++index].charAt(0) == 'x' ? Integer.parseInt(t[index].substring(1), 16) : Integer.parseInt(t[index], 16);
    }

    public boolean testCondition() {
        if (this.r1 == null) {
            return false;
        }
        int rv = this.r1.getValue();
        if (this.endBit != -1) {
            rv >>= this.startBit;
            rv &= ALUOperation.mask[this.endBit - this.startBit + 1];
        } else if (this.startBit != -1) {
            rv >>= this.startBit;
            rv &= 1;
        }
        switch (this.cc) {
            case EQ: {
                return this.value == rv;
            }
            case NE: {
                return this.value != rv;
            }
            case GT: {
                return this.value > rv;
            }
            case GE: {
                return this.value >= rv;
            }
            case LT: {
                return this.value < rv;
            }
            case LE: {
                return this.value <= rv;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("c " + this.r1.getName());
        if (this.startBit != -1) {
            sb.append(" " + this.startBit);
        }
        if (this.endBit != -1) {
            sb.append(" " + this.endBit);
        }
        switch (this.cc) {
            case EQ: {
                sb.append(" EQ ");
                break;
            }
            case NE: {
                sb.append(" NE ");
                break;
            }
            case GT: {
                sb.append(" GT ");
                break;
            }
            case GE: {
                sb.append(" GE ");
                break;
            }
            case LT: {
                sb.append(" LT ");
                break;
            }
            case LE: {
                sb.append(" LE ");
            }
        }
        if (this.value > 9) {
            sb.append("x");
        }
        sb.append(String.format("%x", this.value));
        return sb.toString();
    }
}

