/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLEditorKit;

class ComputerSimulatorFrame
extends JFrame
implements ActionListener,
ItemListener {
    static final long serialVersionUID = 2544741685298068348L;
    static final String helpStringDefault = "This should be help for the ComputerSimulator";
    static final String defaultBaseLocation = "https://asc-lab.web.app/2-2022/cp351004/CompSim/";
    static final String defaultDefinitions = "defs/";
    static final String defaultFileName = "mano.txt";
    static final String defaultFileWebName = "https://asc-lab.web.app/2-2022/cp351004/CompSim/defs/mano.txt";
    static final String defaultHelpName = "helpSimulator.html";
    static final String helpFileWebName = "https://asc-lab.web.app/2-2022/cp351004/CompSim/index.html";
    static String aboutMessage = ComputerSimulator.aboutMessage;
    static final int DISPLAY_ASM_TOP_DIV = 100;
    static final int DISPLAY_ASM_MES_DIV = 500;
    static final int DISPLAY_IO_DIV = 200;
    static final int DISPLAY_IOR_DIV = 200;
    static final int DISPLAY_MID_DIV = 450;
    static final int DISPLAY_LEFT_DIV = 370;
    static final int DISPLAY_DIV = 795;
    int displayASMTopDiv = 100;
    int displayASMMesDiv = 500;
    int displayIODiv = 200;
    int displayIORDiv = 200;
    int displayMidDiv = 450;
    int displayLeftDiv = 370;
    int displayDiv = 795;
    IOFormat inputFormat = IOFormat.ASCII;
    IOFormat outputFormat = IOFormat.ASCII;
    int inputCursor = 0;
    int charsPerLine = 8;
    Container cp;
    File documentFile;
    JLabel jlDocName = new JLabel("Computer Architecture");
    AssemblerPanel assp = new AssemblerPanel((Assembler)null);
    JMenuBar mainMenuBar;
    JMenu menuFile = new JMenu("File");
    JMenu menuLoad = new JMenu("Load");
    JMenu menuControl = new JMenu("Control");
    JMenu menuHelp = new JMenu("Help");
    JMenuItem fmAsm = new JMenuItem("Assembler");
    JMenuItem fmNew = new JMenuItem("New");
    JMenuItem fmSave = new JMenuItem("Save");
    JMenuItem fmSaveAs = new JMenuItem("Save As ...");
    JMenuItem fmPrint = new JMenuItem("Print");
    JMenuItem fmQuit = new JMenuItem("Quit");
    JMenuItem fmOpen = new JMenuItem("Open");
    JMenuItem cmRun = new JMenuItem("Run");
    JMenuItem cmKillRun = new JMenuItem("KillRun");
    JMenuItem cmNextTick = new JMenuItem("Next Tick");
    JMenuItem cmNextInst = new JMenuItem("Next Instruction");
    JMenuItem cmReset = new JMenuItem("Reset");
    JMenuItem cmSetValue = new JMenuItem("Set Value");
    JMenuItem cmClearR = new JMenuItem("Clear Registers");
    JMenuItem cmClearM = new JMenuItem("Clear Memory");
    JMenuItem cmLoadF = new JMenuItem("Load File");
    JMenuItem cmLoadA = new JMenuItem("Load Asm");
    JMenuItem cmDump = new JMenuItem("Dump");
    JMenuItem hmAbout = new JMenuItem("About");
    JMenuItem hmHelpS = new JMenuItem("Simulator Help");
    JMenuItem hmHelpC = new JMenuItem("Computer Help");
    JMenuItem hmHelpA = new JMenuItem("Assembler Help");
    JTextArea jtaMemory = new JTextArea();
    JTextArea jtaMemAddr = new JTextArea();
    JTextArea jtaRegisters = new JTextArea(1, 1);
    JTextArea jtaMessages = new JTextArea(1, 1);
    JTextArea jtaInput = new JTextArea(1, 1);
    JTextArea jtaOutput = new JTextArea(1, 1);
    JScrollPane memorySP;
    JScrollPane registersSP = new JScrollPane(this.jtaRegisters);
    JScrollPane messagesSP = new JScrollPane(this.jtaMessages);
    JScrollPane inputSP = new JScrollPane(this.jtaInput);
    JScrollPane outputSP = new JScrollPane(this.jtaOutput);
    JLabel jlMemory = new JLabel("Memory");
    JLabel jlRegisters = new JLabel("Registers");
    JLabel jlMessages = new JLabel("Simulator Messages");
    JLabel jlInput = new JLabel("Input");
    JLabel jlOutput = new JLabel("Output");
    JPanel pMemory = new JPanel();
    JPanel pMemDisplay = new JPanel();
    JPanel pRegisters = new JPanel();
    JPanel pMessages = new JPanel();
    JPanel pInput = new JPanel();
    JPanel pOutput = new JPanel();
    JPanel plInput = new JPanel();
    JPanel plOutput = new JPanel();
    JPanel plMemory = new JPanel();
    JRadioButton jrbInputHex = new JRadioButton("Hex");
    JRadioButton jrbInputDec = new JRadioButton("Dec");
    JRadioButton jrbInputAscii = new JRadioButton("ASCII");
    JRadioButton jrbOutputHex = new JRadioButton("Hex");
    JRadioButton jrbOutputDec = new JRadioButton("Dec");
    JRadioButton jrbOutputAscii = new JRadioButton("ASCII");
    JComboBox jcbMemSize = new JComboBox<String>(new String[]{"1", "2", "4", "8", "16"});
    ButtonGroup bgInput = new ButtonGroup();
    ButtonGroup bgOutput = new ButtonGroup();
    JSplitPane displayIO = new JSplitPane(0, this.pInput, this.pOutput);
    JSplitPane displayIOR = new JSplitPane(1, this.displayIO, this.pRegisters);
    JSplitPane displayMid = new JSplitPane(0, this.displayIOR, this.pMessages);
    JSplitPane displayLeft = new JSplitPane(1, this.assp, this.displayMid);
    JSplitPane display = new JSplitPane(1, this.displayLeft, this.pMemory);
    JFrame helpFrameS = new JFrame("Simulator Help");
    JFrame helpFrameC = new JFrame("Computer Help");
    JFrame helpFrameA = new JFrame("Assembler Help");
    JEditorPane helpFrameCtxt;
    JEditorPane helpFrameAtxt;
    JToolBar controlPanel = new JToolBar();
    JButton jbKillRun = new JButton("Kill");
    JButton jbRun = new JButton("Run");
    JButton jbNextInstruction = new JButton("Next I");
    JButton jbNextTick = new JButton("Next T");
    JButton jbReset = new JButton("Reset");
    JButton jbSetValue = new JButton("Set Value");
    JButton jbClearR = new JButton("Clear Registers");
    JButton jbClearM = new JButton("Clear Memory");
    JButton jbLoadFile = new JButton("Load Program From File");
    JButton jbLoadAsm = new JButton("Load Program From Assembler");
    JButton jbDump = new JButton("Dump");
    Computer comp;
    boolean runningFlag = false;
    boolean noThreadFlag = true;
    RunType runType = RunType.NONE;
    RunTask runTask;
    Instruction currentInstruction = null;
    Instruction startCycle = null;
    String pcName = "PC";
    String pcStart = "0";
    ArrayList valuesOut = new ArrayList();
    ArrayList valuesIn = new ArrayList();

    public void init() {
        this.comp = new Computer();
        this.assp.setAssembler(this.comp.asm);
        this.cp = this.getContentPane();
        this.cp.setLayout(new BorderLayout());
        this.mainMenuBar = new JMenuBar();
        this.setJMenuBar(this.mainMenuBar);
        this.menuFile.setMnemonic('F');
        this.menuHelp.setMnemonic('H');
        this.menuControl.setMnemonic('C');
        this.mainMenuBar.add(this.menuFile);
        this.mainMenuBar.add(this.menuControl);
        this.mainMenuBar.add(this.menuHelp);
        this.mainMenuBar.add(this.jlDocName);
        this.menuFile.add(this.fmAsm);
        this.menuFile.add(this.menuLoad);
        this.menuFile.add(this.fmNew);
        this.menuFile.add(this.fmSave);
        this.menuFile.add(this.fmSaveAs);
        this.menuFile.add(this.fmPrint);
        this.menuFile.add(this.fmQuit);
        try {
            HTMLParserND hTMLParserND = new HTMLParserND("https://asc-lab.web.app/2-2022/cp351004/CompSim/defs/index.html");
            for (String string : hTMLParserND.getFiles()) {
                if (string.startsWith("Parent")) continue;
                JMenuItem jMenuItem = new JMenuItem(string);
                this.menuLoad.add(jMenuItem);
                jMenuItem.addActionListener(actionEvent -> {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    this.comp.clearComputer();
                    this.readFile("https://asc-lab.web.app/2-2022/cp351004/CompSim/defs/" + jMenuItem.getText());
                });
            }
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "ComputerSimulator.init (creating load submenu)\nMalformed url:\n" + malformedURLException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "ComputerSimulator.init (creating load submenu)\nIOException:\n" + iOException);
        }
        catch (BadLocationException badLocationException) {
            JOptionPane.showMessageDialog(null, "ComputerSimulator.init (creating load submenu)\nBadLocationException:\n" + badLocationException);
        }
        this.menuLoad.add(this.fmOpen);
        this.menuControl.add(this.cmRun);
        this.menuControl.add(this.cmKillRun);
        this.menuControl.add(this.cmNextTick);
        this.menuControl.add(this.cmNextInst);
        this.menuControl.add(this.cmReset);
        this.menuControl.add(this.cmSetValue);
        this.menuControl.add(this.cmClearR);
        this.menuControl.add(this.cmClearM);
        this.menuControl.add(this.cmLoadF);
        this.menuControl.add(this.cmLoadA);
        this.menuControl.add(this.cmDump);
        this.menuHelp.add(this.hmAbout);
        this.menuHelp.add(this.hmHelpS);
        this.menuHelp.add(this.hmHelpC);
        this.menuHelp.add(this.hmHelpA);
        this.fmAsm.addActionListener(this);
        this.fmAsm.setAccelerator(KeyStroke.getKeyStroke(120, 2));
        this.fmNew.addActionListener(this);
        this.fmNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.fmOpen.addActionListener(this);
        this.fmOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fmSave.addActionListener(this);
        this.fmSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fmSaveAs.addActionListener(this);
        this.fmPrint.addActionListener(this);
        this.fmPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fmQuit.addActionListener(this);
        this.fmQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.cmRun.addActionListener(this);
        this.cmNextTick.addActionListener(this);
        this.cmNextTick.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.cmNextInst.addActionListener(this);
        this.cmNextInst.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.cmReset.addActionListener(this);
        this.cmReset.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.cmSetValue.addActionListener(this);
        this.cmSetValue.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.cmClearR.addActionListener(this);
        this.cmClearR.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.cmClearM.addActionListener(this);
        this.cmClearM.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.cmLoadF.addActionListener(this);
        this.cmLoadF.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.cmLoadA.addActionListener(this);
        this.cmLoadA.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.cmDump.addActionListener(this);
        this.cmDump.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.hmAbout.addActionListener(this);
        this.hmHelpS.addActionListener(this);
        this.hmHelpS.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.hmHelpC.addActionListener(this);
        this.hmHelpC.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.hmHelpA.addActionListener(this);
        this.hmHelpA.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.pRegisters.setLayout(new BorderLayout());
        this.pRegisters.add((Component)this.jlRegisters, "North");
        this.pRegisters.add((Component)this.registersSP, "Center");
        this.pMessages.setLayout(new BorderLayout());
        this.pMessages.add((Component)this.jlMessages, "North");
        this.pMessages.add((Component)this.messagesSP, "Center");
        this.jtaMemory.setFont(new Font("monospaced", 0, 12));
        this.jtaMemAddr.setFont(new Font("monospaced", 0, 12));
        this.pMemDisplay.setLayout(new BorderLayout());
        this.pMemDisplay.add((Component)this.jtaMemAddr, "West");
        this.pMemDisplay.add((Component)this.jtaMemory, "Center");
        this.memorySP = new JScrollPane(this.pMemDisplay);
        this.plMemory.setLayout(new FlowLayout());
        this.plMemory.add(this.jlMemory);
        this.jlMemory.setToolTipText("Set number of words to display on each line");
        this.jcbMemSize.setSelectedItem("16");
        this.plMemory.add(this.jcbMemSize);
        this.pMemory.setLayout(new BorderLayout());
        this.pMemory.add((Component)this.plMemory, "North");
        this.pMemory.add((Component)this.memorySP, "Center");
        this.jtaMemAddr.setText("fff");
        this.plInput.setLayout(new FlowLayout());
        this.plInput.add(this.jlInput);
        this.jrbInputAscii.setSelected(true);
        this.bgInput.add(this.jrbInputAscii);
        this.bgInput.add(this.jrbInputHex);
        this.bgInput.add(this.jrbInputDec);
        this.plInput.add(this.jrbInputAscii);
        this.plInput.add(this.jrbInputHex);
        this.plInput.add(this.jrbInputDec);
        this.pInput.setLayout(new BorderLayout());
        this.pInput.add((Component)this.plInput, "North");
        this.pInput.add((Component)this.inputSP, "Center");
        this.plOutput.setLayout(new FlowLayout());
        this.plOutput.add(this.jlOutput);
        this.jrbOutputAscii.setSelected(true);
        this.bgOutput.add(this.jrbOutputAscii);
        this.bgOutput.add(this.jrbOutputHex);
        this.bgOutput.add(this.jrbOutputDec);
        this.plOutput.add(this.jrbOutputAscii);
        this.plOutput.add(this.jrbOutputHex);
        this.plOutput.add(this.jrbOutputDec);
        this.pOutput.setLayout(new BorderLayout());
        this.pOutput.add((Component)this.plOutput, "North");
        this.pOutput.add((Component)this.outputSP, "Center");
        this.display.setOneTouchExpandable(true);
        this.jtaRegisters.setFont(new Font("Monospaced", 0, 12));
        this.jtaMessages.setFont(new Font("Monospaced", 0, 12));
        this.jtaInput.setFont(new Font("Monospaced", 0, 12));
        this.jtaOutput.setFont(new Font("Monospaced", 0, 12));
        this.cp.add(this.display);
        this.jbKillRun.setBackground(Color.red);
        this.jbRun.setBackground(Color.green);
        this.jbLoadAsm.setBackground(Color.orange);
        this.jbReset.setBackground(Color.orange);
        this.jbRun.addActionListener(this);
        this.jbRun.setToolTipText("Run to halt instruction");
        this.jbNextInstruction.addActionListener(this);
        this.jbNextInstruction.setToolTipText("Next Instruction - Shortcut: Ctrl-G");
        this.jbNextTick.addActionListener(this);
        this.jbNextTick.setToolTipText("Next Clock Tick - Shortcut: Ctrl-F");
        this.jbReset.addActionListener(this);
        this.jbReset.setToolTipText("PC <- start - Shortcut: Ctrl-R");
        this.jbSetValue.addActionListener(this);
        this.jbSetValue.setToolTipText("Sets Register or Memory Value - Shortcut: Ctrl-J");
        this.jbClearR.addActionListener(this);
        this.jbClearR.setToolTipText("Clears the Registers - Shortcut: Ctrl-B");
        this.jbClearM.addActionListener(this);
        this.jbClearM.setToolTipText("Clears the Memory - Shortcut: Ctrl-M");
        this.jbLoadFile.addActionListener(this);
        this.jbLoadFile.setToolTipText("Adds Computer Specifications - Shortcut: Ctrl-F");
        this.jbLoadAsm.addActionListener(this);
        this.jbLoadAsm.setToolTipText("Adds Computer Specifications - Shortcut: Ctrl-L");
        this.jbDump.addActionListener(this);
        this.jbDump.setToolTipText("Various Information in Messages Window - Shortcut: Ctrl-D");
        this.enableButtons(0);
        this.controlPanel.add(this.jbLoadAsm);
        this.controlPanel.add(this.jbReset);
        this.controlPanel.add(this.jbNextTick);
        this.controlPanel.add(this.jbNextInstruction);
        this.controlPanel.add(this.jbRun);
        this.controlPanel.add(this.jbKillRun);
        this.controlPanel.add(this.jbSetValue);
        this.controlPanel.add(this.jbClearR);
        this.controlPanel.add(this.jbClearM);
        this.controlPanel.add(this.jbLoadFile);
        this.controlPanel.add(this.jbDump);
        this.cp.add((Component)this.controlPanel, "North");
        this.initHelpFrameS(helpFileWebName);
        this.helpFrameCtxt = this.initHelpFrame(this.helpFrameC, "Help for the particular computer architecture should be here");
        this.helpFrameAtxt = this.initHelpFrame(this.helpFrameA, "Help for the particular computer assembler should be here");
        if (this.documentFile == null) {
            this.readFile(defaultFileWebName);
        }
        this.resetDisplayAreas();
        this.addButtonListeners();
        this.cmKillRun.addActionListener(this);
        this.jbKillRun.addActionListener(this);
        this.jbKillRun.setToolTipText("Stop a run");
    }

    void addButtonListeners() {
        this.jrbInputHex.addActionListener(this);
        this.jrbInputDec.addActionListener(this);
        this.jrbInputAscii.addActionListener(this);
        this.jrbOutputHex.addActionListener(this);
        this.jrbOutputDec.addActionListener(this);
        this.jrbOutputAscii.addActionListener(this);
        this.jcbMemSize.addActionListener(this);
    }

    void resetDisplayAreas() {
        this.assp.resetDislpayAreas(this.displayASMTopDiv, this.displayASMMesDiv);
        this.displayIO.setDividerLocation(this.displayIODiv);
        this.displayIOR.setDividerLocation(this.displayIORDiv);
        this.displayMid.setDividerLocation(this.displayMidDiv);
        this.displayLeft.setDividerLocation(this.displayLeftDiv);
        this.display.setDividerLocation(this.displayDiv);
        this.display.setResizeWeight(1.0);
        this.displayLeft.setResizeWeight(1.0);
        this.displayIOR.setResizeWeight(1.0);
    }

    void toggleDislpay(JPanel jPanel) {
        boolean bl = !jPanel.isVisible();
        jPanel.setVisible(bl);
        this.resetDisplayAreas();
    }

    private void enableButtons(int n) {
        this.jbKillRun.setEnabled(false);
        this.jbRun.setEnabled(false);
        this.jbNextInstruction.setEnabled(false);
        this.jbNextTick.setEnabled(false);
        this.jbReset.setEnabled(false);
        this.jbSetValue.setEnabled(false);
        this.jbClearR.setEnabled(false);
        this.jbClearM.setEnabled(false);
        this.jbLoadFile.setEnabled(false);
        this.jbLoadAsm.setEnabled(false);
        this.jbDump.setEnabled(false);
        switch (n) {
            case 2: {
                this.jbKillRun.setEnabled(true);
                this.jbRun.setEnabled(true);
                this.jbNextInstruction.setEnabled(true);
                this.jbNextTick.setEnabled(true);
            }
            case 1: {
                this.jbSetValue.setEnabled(true);
                this.jbReset.setEnabled(true);
                this.jbClearR.setEnabled(true);
                this.jbClearM.setEnabled(true);
                this.jbLoadFile.setEnabled(true);
                this.jbLoadAsm.setEnabled(true);
                this.jbDump.setEnabled(true);
            }
        }
    }

    private void initHelpFrameS(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(true);
        jEditorPane.setEditorKit(new HTMLEditorKit());
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(new Dimension(800, 600));
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.helpFrameS.getContentPane().add(jScrollPane);
        this.helpFrameS.pack();
        this.helpFrameS.setLocationRelativeTo(null);
        try {
            jEditorPane.setPage(string);
            jEditorPane.setCaretPosition(0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "ComputerSimulator.initHelpFrameS (a): exception reading help\n" + iOException.toString().replaceAll(",", "\n"));
        }
        jEditorPane.addHyperlinkListener(hyperlinkEvent -> {
            try {
                if (hyperlinkEvent.getURL() == null) {
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "ComputerSimulator.initHelpFrameS (b): exception reading help\n" + iOException.toString().replaceAll(",", "\n"));
            }
        });
    }

    private JEditorPane initHelpFrame(JFrame jFrame, String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(true);
        jEditorPane.setEditorKit(new HTMLEditorKit());
        jEditorPane.setText(string);
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(new Dimension(800, 500));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        return jEditorPane;
    }

    private void readHelp(String[] stringArray, Scanner scanner, JEditorPane jEditorPane) {
        Object object = new String();
        String string = "";
        while (scanner.hasNextLine() && !(string = scanner.nextLine()).equals("endHelp")) {
            object = (String)object + string + "\n";
        }
        jEditorPane.setText((String)object);
        jEditorPane.setCaretPosition(0);
    }

    public void processInput(String string, Scanner scanner) {
        String[] stringArray = string.split(",");
        if (stringArray[0].equals("ram")) {
            this.comp.ram = new Memory(stringArray, this.jtaMemory, this.comp);
        }
        if (stringArray[0].equals("iram")) {
            this.comp.iram = new Memory(stringArray, this.jtaMemory, this.comp);
        }
        if (stringArray[0].equals("cram")) {
            this.comp.cram = new Memory(stringArray, this.jtaMemory, this.comp);
        }
        if (stringArray[0].equals("register")) {
            this.comp.registerFile.add(new Register(stringArray));
        }
        if (stringArray[0].equals("flag")) {
            this.comp.flagFile.add(new Flag(stringArray));
        }
        if (stringArray[0].equals("loadRam")) {
            this.readRam(this.comp.ram, stringArray, scanner);
        }
        if (stringArray[0].equals("loadIRam")) {
            this.readRam(this.comp.iram, stringArray, scanner);
        }
        if (stringArray[0].equals("loadCRam")) {
            this.readRam(this.comp.cram, stringArray, scanner);
        }
        if (stringArray[0].equals("setRegister")) {
            this.setRegister(stringArray);
        }
        if (stringArray[0].equals("setFlag")) {
            this.setFlag(stringArray);
        }
        if (stringArray[0].equals("RTLinstructions")) {
            this.readInstructions(stringArray, scanner);
        }
        if (stringArray[0].equals("assembler")) {
            this.readAssembler(stringArray, scanner);
        }
        if (stringArray[0].equals("helpComputer")) {
            this.readHelp(stringArray, scanner, this.helpFrameCtxt);
        }
        if (stringArray[0].equals("helpAssembler")) {
            this.readHelp(stringArray, scanner, this.helpFrameAtxt);
        }
        if (stringArray[0].equals("PCStart")) {
            this.setPCstart(stringArray);
        }
        if (stringArray[0].equals("InstructionCycleStart")) {
            this.setICstart(stringArray[1]);
        }
    }

    public void readFile(String string) {
        String string2 = null;
        File file = this.documentFile;
        File file2 = null;
        Scanner scanner = null;
        try {
            if (string == null) {
                int n;
                if (file == null) {
                    file = new File(".");
                }
                if ((n = ((JFileChooser)(var6_6 = new JFileChooser(file))).showOpenDialog(null)) != 0) {
                    return;
                }
                file2 = ((JFileChooser)var6_6).getSelectedFile();
                string = file2.getName();
                scanner = new Scanner(file2);
            } else if (defaultFileName.startsWith("../")) {
                string = defaultFileName;
                scanner = new Scanner(new File(defaultFileName));
            } else {
                var6_6 = new URL(string);
                URLConnection uRLConnection = ((URL)var6_6).openConnection();
                scanner = new Scanner(new InputStreamReader(uRLConnection.getInputStream()));
            }
            this.comp.clearComputer();
            this.clearDisplays();
            while (scanner.hasNextLine()) {
                string2 = scanner.nextLine();
                this.processInput(string2, scanner);
            }
            scanner.close();
            this.comp.normalize(this.jtaMemAddr);
            this.updateDisplay();
            this.updateMemoryDisplay();
            JOptionPane.showMessageDialog(null, "ASC Data Repository Server: CONNECTED\nFile retrieved: " + string);
            this.documentFile = file2;
            this.jlDocName.setText("  Computer Architecture: " + string);
            this.mainMenuBar.validate();
            this.enableButtons(1);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "ASC Data Repository Server: DISCONNECTED\nFile read FAILED (a)\n" + string2 + "\n" + iOException);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "ASC Data Repository Server: DISCONNECTED\nFile read FAILED (b)\n" + string2 + "\n" + exception);
        }
    }

    private void readAsmFile() {
        String string = null;
        try {
            String string2 = this.assp.machineTA.getText();
            Scanner scanner = new Scanner(string2);
            while (scanner.hasNextLine()) {
                string = scanner.nextLine();
                this.processInput(string, scanner);
            }
            this.jtaMessages.setText("Code:\n\n" + string2);
            this.comp.ram.changed = -1;
            this.updateDisplay();
            JOptionPane.showMessageDialog(null, "Assembler read OK: ");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Assembler read FAILED\n" + string + "\n" + exception);
        }
    }

    private void readRam(Memory memory, String[] stringArray, Scanner scanner) {
        if (scanner.hasNextLine()) {
            String string;
            int n = 16;
            if (memory == this.comp.cram) {
                n = 2;
            }
            while (scanner.hasNextLine() && !(string = scanner.nextLine()).equals("endLoadRam")) {
                Scanner scanner2 = new Scanner(string);
                scanner2.useDelimiter("[\\s:]+");
                if (!scanner2.hasNextInt(n)) continue;
                int n2 = scanner2.nextInt(16);
                while (scanner2.hasNextInt(n)) {
                    memory.setMemory(n2++, scanner2.nextInt(n));
                }
            }
            if (memory == this.comp.ram) {
                this.jtaMemAddr.setText(memory.toAddrString());
                this.jtaMemory.setText(memory.toString());
                this.jtaMemory.setCaretPosition(0);
            }
        }
    }

    public int getPCValue() {
        return this.comp.getRegisterByName(this.pcName).getValue();
    }

    public void setRegister(String string, String string2) {
        RegisterFunctions registerFunctions = this.comp.getRegisterByName(string.trim());
        if (registerFunctions == null) {
            JOptionPane.showMessageDialog(null, "Register not found: >" + string + "<");
        } else {
            try {
                registerFunctions.setValue(Integer.parseInt(string2.trim(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "ComputerSimulator.setRegister - Number format on: >" + string + " to " + string2 + "<");
            }
        }
    }

    public void setRegister(String[] stringArray) {
        this.setRegister(stringArray[1], stringArray[2]);
    }

    private void setValueDialog() {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Possible Registers: ");
        for (Object object2 : this.comp.registerFile) {
            stringBuffer.append(", " + ((Register)object2).getName());
        }
        stringBuffer.append("\nExample: PC 1234\nMemory changes example:\nM 1234 33");
        object2 = JOptionPane.showInputDialog(stringBuffer);
        if (object2 != null) {
            String[] stringArray = ((String)object2).split("[\\s]");
            if (stringArray.length == 2) {
                this.setRegister(stringArray[0], stringArray[1]);
            }
            if (stringArray.length == 3) {
                this.comp.writeMemory(Integer.parseInt(stringArray[1], 16), Integer.parseInt(stringArray[2], 16));
            }
            this.updateDisplay();
        }
    }

    public void setFlag(String[] stringArray) {
        Flag flag = null;
        for (Flag flag2 : this.comp.flagFile) {
            if (!stringArray[1].trim().equals(flag2.getName())) continue;
            flag = flag2;
            break;
        }
        if (flag == null) {
            JOptionPane.showMessageDialog(null, "Flag not found: " + stringArray[1]);
        } else {
            flag.setValue(Integer.parseInt(stringArray[2].trim(), 16));
        }
    }

    private void readInstructions(String[] stringArray, Scanner scanner) {
        if (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            while (!string.equals("endInstructions") && scanner.hasNextLine()) {
                if (string.length() > 0 && string.charAt(0) != '/') {
                    Instruction instruction = new Instruction(this.comp, string);
                    this.comp.instructionSet.add(instruction);
                }
                string = scanner.nextLine();
            }
        }
    }

    private void readAssembler(String[] stringArray, Scanner scanner) {
        if (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            while (!string.equals("endAssembler") && scanner.hasNextLine()) {
                if (string.length() > 0 && string.charAt(0) != '/') {
                    this.comp.asm.processLine(string);
                }
                string = scanner.nextLine();
            }
        }
    }

    private void clearDisplays() {
        this.jtaMemory.setText("");
        this.jtaRegisters.setText("");
        this.jtaMessages.setText("");
        this.jtaInput.setText("");
        this.jtaOutput.setText("");
    }

    private void updateDisplay() {
        this.jtaRegisters.setText(this.comp.registerFile.toString());
        this.jtaRegisters.append("\n" + this.comp.flagFile.toString());
        this.jtaRegisters.setCaretPosition(0);
        this.jtaRegisters.setEditable(false);
        if (this.comp.hasNewOutput()) {
            int n = this.comp.getRegisterByName("SimulatorOutput").getValue();
            this.valuesOut.add(n);
            this.comp.setNewOutput(false);
            Object object = "";
            Iterator iterator = this.valuesOut.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                switch (this.outputFormat) {
                    case HEX: {
                        object = (String)object + Integer.toHexString(n2) + " ";
                        break;
                    }
                    case ASCII: {
                        object = (String)object + Character.toString((char)n2);
                        break;
                    }
                    case DEC: {
                        object = (String)object + String.format("%,d ", n2);
                    }
                }
            }
            this.jtaOutput.setText((String)object);
        }
    }

    private void updateMemoryDisplay() {
        this.jtaMemory.setEditable(true);
        String string = this.comp.ram.toString();
        this.jtaMemory.setText(string);
        this.jtaMemory.setCaretPosition(0);
        this.jtaMemory.setEditable(false);
    }

    private void clearRegisters() {
        this.comp.registerFile.clearFile();
        this.comp.flagFile.clearFile();
        this.updateDisplay();
    }

    private void clearMemory() {
        this.comp.ram.clearMemory();
        this.updateDisplay();
    }

    private void setPCstart(String[] stringArray) {
        this.pcName = stringArray[1].trim();
        this.pcStart = stringArray[2];
    }

    private void setICstart(String string) {
        int n = Integer.parseInt(string.trim());
        for (Instruction instruction : this.comp.instructionSet) {
            if (instruction.index != n) continue;
            this.startCycle = instruction;
            break;
        }
    }

    private void setupInput() {
        if (this.comp.getRegisterByName("SimulatorHasInput").getValue() != 1) {
            String string = this.jtaInput.getText();
            if (this.inputFormat == IOFormat.ASCII) {
                if (string.length() <= this.inputCursor) {
                    return;
                }
                char c = string.charAt(this.inputCursor++);
                this.comp.getRegisterByName("SimulatorInput").setValue(c);
                this.comp.getRegisterByName("SimulatorHasInput").setValue(1);
            } else {
                String[] stringArray = string.split("[\\s]+");
                if (stringArray.length <= this.inputCursor) {
                    return;
                }
                if (stringArray[this.inputCursor].length() == 0) {
                    return;
                }
                try {
                    int n = Integer.parseInt(stringArray[this.inputCursor++].trim(), 16);
                    this.comp.getRegisterByName("SimulatorInput").setValue(n);
                    this.comp.getRegisterByName("SimulatorHasInput").setValue(1);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "ComputerSimulator.setupInput - Number format on: >" + stringArray[--this.inputCursor] + "<");
                    this.runningFlag = false;
                }
            }
        }
    }

    private void processTick(boolean bl) {
        if (this.runningFlag) {
            this.setupInput();
            Instruction instruction = this.currentInstruction;
            this.currentInstruction = this.currentInstruction.execute();
            if (this.currentInstruction == null) {
                if (instruction.getHaltFlag()) {
                    JOptionPane.showMessageDialog(null, "ComputerSimulator.processTick\nHalt instruction encountered\nEnd Simulation");
                } else {
                    JOptionPane.showMessageDialog(null, "ComputerSimulator.processTick - No matching conditions: \n" + instruction);
                }
                this.runningFlag = false;
            }
            if (this.runningFlag) {
                if (bl) {
                    this.jtaMessages.append("Next Instruction:\n" + this.currentInstruction.toString() + "\n");
                    this.updateMemoryDisplay();
                }
            } else {
                this.jtaMessages.append("Simulation over");
                this.enableButtons(1);
            }
            this.updateDisplay();
        }
    }

    private void processInstruction(boolean bl) {
        if (this.runningFlag) {
            this.comp.ram.PCold = this.getPCValue();
            this.processTick(false);
            while (this.runningFlag && this.currentInstruction != this.startCycle) {
                this.processTick(false);
            }
            this.comp.ram.PCnew = this.getPCValue();
            if (bl) {
                this.updateDisplay();
                this.comp.ram.updatePCHighlights();
            }
        }
    }

    private void processRun() {
        this.comp.ram.skipUpdate = true;
        while (this.runningFlag) {
            this.processInstruction(false);
        }
        this.comp.ram.skipUpdate = false;
        this.updateMemoryDisplay();
    }

    private void startRun() {
        this.runningFlag = true;
        this.inputCursor = 0;
        this.comp.getRegisterByName("SimulatorInput").setValue(0);
        this.comp.getRegisterByName("SimulatorHasInput").setValue(0);
        this.jtaMessages.setText("Starting simulation\n");
        this.setRegister(this.pcName, this.pcStart);
        for (Instruction instruction : this.comp.instructionSet) {
            if (!instruction.isInitialInstruction()) continue;
            this.currentInstruction = instruction;
            break;
        }
        this.enableButtons(2);
        this.updateDisplay();
    }

    public void runWork() {
        this.noThreadFlag = false;
        this.runTask = new RunTask();
        this.runTask.execute();
    }

    public void killRun() {
        this.runningFlag = false;
        this.jtaMessages.append("Simulation over");
        this.enableButtons(1);
        this.updateDisplay();
        JOptionPane.showMessageDialog(null, "Stop run: Simulation Killed by user.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fmAsm) {
            this.toggleDislpay(this.assp);
        }
        if (object == this.fmNew) {
            System.out.println("New");
        }
        if (object == this.fmOpen) {
            this.readFile(null);
        }
        if (object == this.fmSave) {
            System.out.println("Save");
        }
        if (object == this.fmSaveAs) {
            System.out.println("Save As");
        }
        if (object == this.fmPrint) {
            System.out.println("Print");
        }
        if (object == this.fmQuit) {
            System.exit(0);
        }
        if (object == this.hmAbout) {
            JOptionPane.showMessageDialog(null, aboutMessage);
        }
        if (object == this.hmHelpS) {
            this.helpFrameS.setVisible(true);
        }
        if (object == this.hmHelpC) {
            this.helpFrameC.setVisible(true);
        }
        if (object == this.hmHelpA) {
            this.helpFrameA.setVisible(true);
        }
        if (object == this.jbRun || object == this.cmRun) {
            this.runType = RunType.END;
            this.runWork();
        }
        if (object == this.jbNextInstruction || object == this.cmNextInst) {
            this.runType = RunType.INSTRUCTION;
            this.runWork();
        }
        if (object == this.jbNextTick || object == this.cmNextTick) {
            this.runType = RunType.TICK;
            this.runWork();
        }
        if (object == this.jbReset || object == this.cmReset) {
            this.startRun();
        }
        if (object == this.jbKillRun) {
            this.killRun();
        }
        if (object == this.jbSetValue || object == this.cmSetValue) {
            this.setValueDialog();
        }
        if (object == this.jbClearR || object == this.cmClearR) {
            this.clearRegisters();
        }
        if (object == this.jbClearM || object == this.cmClearM) {
            this.clearMemory();
        }
        if (object == this.jbLoadFile || object == this.cmLoadF) {
            this.readFile(null);
        }
        if (object == this.jbLoadAsm || object == this.cmLoadA) {
            this.readAsmFile();
        }
        if (object == this.jbDump || object == this.cmDump) {
            this.dump();
        }
        if (object == this.jcbMemSize) {
            this.updateMemorySize();
        }
        if (object == this.jrbInputAscii) {
            this.updateIODisplay(this.jtaInput, IOFormat.ASCII);
        }
        if (object == this.jrbInputHex) {
            this.updateIODisplay(this.jtaInput, IOFormat.HEX);
        }
        if (object == this.jrbInputDec) {
            this.updateIODisplay(this.jtaInput, IOFormat.DEC);
        }
        if (object == this.jrbOutputAscii) {
            this.updateIODisplay(this.jtaOutput, IOFormat.ASCII);
        }
        if (object == this.jrbOutputHex) {
            this.updateIODisplay(this.jtaOutput, IOFormat.HEX);
        }
        if (object == this.jrbOutputDec) {
            this.updateIODisplay(this.jtaOutput, IOFormat.DEC);
        }
        if (this.noThreadFlag) {
            this.updateMemoryDisplay();
        }
    }

    void updateMemorySize() {
        this.comp.ram.setColumns(this.power(2, this.jcbMemSize.getSelectedIndex()), this.jtaMemAddr);
        this.updateMemoryDisplay();
    }

    int power(int n, int n2) {
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public void updateIODisplay(JTextArea jTextArea, IOFormat iOFormat) {
        if (jTextArea == this.jtaInput) {
            if (iOFormat == this.inputFormat) {
                return;
            }
            this.inputFormat = iOFormat;
        } else {
            if (jTextArea != this.jtaOutput) {
                return;
            }
            if (iOFormat == this.outputFormat) {
                return;
            }
            this.outputFormat = iOFormat;
        }
        Object object = "";
        Iterator iterator = this.valuesOut.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            switch (this.outputFormat) {
                case HEX: {
                    object = (String)object + Integer.toHexString(n) + " ";
                    break;
                }
                case ASCII: {
                    object = (String)object + Character.toString((char)n);
                    break;
                }
                case DEC: {
                    object = (String)object + String.format("%,d ", n);
                }
            }
        }
        jTextArea.setText((String)object);
    }

    public void dump() {
        this.jtaMessages.setText("");
        this.jtaMessages.append("Instruction Memory:\n" + this.comp.iram + "\n");
        this.jtaMessages.append("Control Memory:\n" + this.comp.cram + "\n");
        this.jtaMessages.append("RTL Instruction Set:\n" + this.comp.toStringInstructionSet());
        this.jtaMessages.append(this.comp.asm.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        System.out.println("item event: " + itemEvent);
    }

    public ComputerSimulatorFrame() {
        this.setBackground(Color.green);
        this.setTitle("Computer Simulator by Nicholas Duchon (MAINTAINED BY ASC DATA REPOSITORY)");
        this.setSize(1450, 800);
        this.setLocationRelativeTo(null);
        this.init();
        this.setVisible(true);
    }

    private class RunTask
    extends SwingWorker {
        private RunTask() {
        }

        public Void doInBackground() {
            switch (ComputerSimulatorFrame.this.runType) {
                case TICK: {
                    ComputerSimulatorFrame.this.processTick(true);
                    break;
                }
                case INSTRUCTION: {
                    ComputerSimulatorFrame.this.processInstruction(true);
                    break;
                }
                case END: {
                    ComputerSimulatorFrame.this.processRun();
                }
            }
            ComputerSimulatorFrame.this.noThreadFlag = true;
            return null;
        }

        RunTask(Object object) {
            this();
        }
    }
}

