/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextArea;

class Computer
implements ComputerInterface {
    static final String R_SIM_IN = "SimulatorInput";
    static final String R_SIM_OUT = "SimulatorOutput";
    static final String F_SIM_IN = "SimulatorHasInput";
    Memory ram;
    Memory cram;
    Memory iram;
    boolean newInput = false;
    boolean newOutput = false;
    Register output = new Register(new String[]{"name SimulatorOutput", "size 8"});
    Register input = new Register(new String[]{"name SimulatorInput", "size 8"});
    Flag hasInput = new Flag(new String[]{"name SimulatorHasInput"});
    GroupFile registerFile = new GroupFile("Registers");
    GroupFile flagFile = new GroupFile("Flags");
    ArrayList instructionSet = new ArrayList();
    Assembler asm = new Assembler();

    public Computer() {
        this.output.displayBinary(false);
        this.input.displayBinary(false);
        this.hasInput.displayBinary(false);
    }

    public void clearComputer() {
        this.cram = null;
        this.iram = null;
        this.ram = null;
        this.registerFile.clear();
        this.registerFile.add(this.output);
        this.registerFile.add(this.input);
        this.flagFile.clear();
        this.flagFile.add(this.hasInput);
        this.instructionSet.clear();
        this.asm.clear();
    }

    public void normalize(JTextArea jTextArea) {
        if (this.cram != null) {
            this.cram.setColumns(8, jTextArea);
        }
        if (this.iram != null) {
            this.iram.setColumns(8, jTextArea);
        }
    }

    @Override
    public RegisterFunctions getRegisterByName(String string) {
        RegisterFunctions registerFunctions;
        Iterator iterator = this.registerFile.iterator();
        do {
            if (iterator.hasNext()) continue;
            iterator = this.flagFile.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(registerFunctions = (RegisterFunctions)iterator.next()).getName().equals(string));
            return registerFunctions;
        } while (!(registerFunctions = (RegisterFunctions)iterator.next()).getName().equals(string));
        return registerFunctions;
    }

    @Override
    public int readMemory(int n) {
        return this.ram.getMemory(n);
    }

    @Override
    public boolean writeMemory(int n, int n2) {
        return this.ram.setMemory(n, n2);
    }

    @Override
    public void setNewOutput(boolean bl) {
        this.newOutput = bl;
    }

    @Override
    public boolean hasNewOutput() {
        return this.newOutput;
    }

    public String toStringInstructionSet() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Instruction instruction : this.instructionSet) {
            stringBuffer.append(instruction + "\n");
        }
        return stringBuffer.toString();
    }
}

