/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class AssemblerPanel
extends JPanel
implements ActionListener,
KeyListener {
    static final long serialVersionUID = 3800099848963174524L;
    int displayTopDiv = 100;
    int dislpayDiv = 500;
    Assembler asm;
    JTextArea codeTA = new JTextArea();
    JTextArea machineTA = new JTextArea();
    JTextPane jepMessages = new JTextPane();
    Highlighter hilit;
    Highlighter.HighlightPainter painterRed;
    Highlighter.HighlightPainter painterChng;
    Highlighter.HighlightPainter painterPrev;
    Highlighter.HighlightPainter painterNext;
    JLabel codeL = new JLabel("Source Code");
    JLabel machineL = new JLabel("Machine Code");
    JLabel messagesL = new JLabel("Assembler Messages");
    JButton jbAssemble = new JButton("Assemble");
    JButton jbDump = new JButton("Dump");
    JPanel codeP = new JPanel();
    JPanel machineP = new JPanel();
    JPanel messagesP = new JPanel();
    JToolBar controlPanel = new JToolBar();
    JScrollPane codeSP;
    JScrollPane machineSP;
    BoundedRangeModel brmMachineSP;
    MyBasicScrollBarUI mbsbMachineKnob = new MyBasicScrollBarUI();
    MyBasicScrollBarUI mbsbCodeKnob = new MyBasicScrollBarUI();
    MyBasicScrollBarUI mbsbMessageKnob = new MyBasicScrollBarUI();
    JScrollPane messagesSP;
    JSplitPane displayTop;
    JSplitPane display;

    public AssemblerPanel(Assembler assembler) {
        this.asm = assembler;
        this.setBackground(Color.green);
        this.setLayout(new BorderLayout());
        this.codeSP = new JScrollPane(this.codeTA);
        this.machineSP = new JScrollPane(this.machineTA);
        this.codeSP.getVerticalScrollBar().setUI(this.mbsbCodeKnob);
        this.mbsbCodeKnob.setColor(Color.green);
        this.machineSP.getVerticalScrollBar().setUI(this.mbsbMachineKnob);
        this.mbsbMachineKnob.setColor(Color.yellow);
        this.brmMachineSP = this.machineSP.getVerticalScrollBar().getModel();
        this.codeSP.setHorizontalScrollBarPolicy(32);
        this.machineSP.setHorizontalScrollBarPolicy(32);
        this.messagesSP = new JScrollPane(this.jepMessages);
        this.messagesSP.getVerticalScrollBar().setUI(this.mbsbMessageKnob);
        this.mbsbMessageKnob.setColor(Color.yellow);
        this.codeP.setLayout(new BorderLayout());
        this.machineP.setLayout(new BorderLayout());
        this.messagesP.setLayout(new BorderLayout());
        this.codeP.add((Component)this.codeL, "North");
        this.codeP.add((Component)this.codeSP, "Center");
        this.machineP.add((Component)this.machineL, "North");
        this.machineP.add((Component)this.machineSP, "Center");
        this.messagesP.add((Component)this.messagesL, "North");
        this.messagesP.add((Component)this.messagesSP, "Center");
        this.displayTop = new JSplitPane(1, this.machineP, this.codeP);
        this.display = new JSplitPane(0, this.displayTop, this.messagesP);
        this.display.setOneTouchExpandable(true);
        this.codeTA.setFont(new Font("Monospaced", 0, 12));
        this.machineTA.setFont(new Font("Monospaced", 0, 12));
        this.jepMessages.setFont(new Font("Monospaced", 0, 12));
        this.codeTA.setText("");
        this.machineTA.setText("");
        this.machineTA.setBackground(Color.yellow);
        this.jepMessages.setText("");
        this.hilit = new DefaultHighlighter();
        this.painterRed = new DefaultHighlighter.DefaultHighlightPainter(Color.red);
        this.painterChng = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 170, 170));
        this.painterPrev = new DefaultHighlighter.DefaultHighlightPainter(new Color(170, 255, 170));
        this.painterNext = new DefaultHighlighter.DefaultHighlightPainter(new Color(170, 170, 255));
        this.codeTA.setHighlighter(this.hilit);
        this.jbAssemble.setBackground(Color.cyan);
        this.jbAssemble.addActionListener(this);
        this.jbDump.addActionListener(this);
        this.codeTA.addKeyListener(this);
        this.controlPanel.add(this.jbAssemble);
        this.controlPanel.add(this.jbDump);
        this.add((Component)this.controlPanel, "North");
        this.add(this.display);
        this.resetDisplayAreas();
    }

    public void resetDislpayAreas(int n, int n2) {
        this.displayTop.setDividerLocation(n);
        this.display.setDividerLocation(n2);
    }

    public void resetDisplayAreas() {
        this.resetDislpayAreas(this.displayTopDiv, this.dislpayDiv);
    }

    public void setAssembler(Assembler assembler) {
        this.asm = assembler;
    }

    public void dump() {
        this.jepMessages.setText(this.asm.toString());
        this.hilit.removeAllHighlights();
    }

    public void assemble() {
        if (this.asm == null) {
            this.jepMessages.setText("No assembler specified");
        } else {
            try {
                this.machineTA.setText(this.asm.assemble(this.codeTA.getText()));
                this.machineTA.setCaretPosition(0);
                if (this.asm.successfulFlag) {
                    this.mbsbMessageKnob.setColor(Color.green);
                } else {
                    this.mbsbMessageKnob.setColor(Color.red);
                }
                this.jepMessages.setText("Assembling ...\n" + this.asm.getMessages() + "\n");
                Object[] objectArray = this.asm.symbols.keySet().toArray();
                Object[][] objectArray2 = new Object[objectArray.length][2];
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray2[i][1] = objectArray[i];
                    objectArray2[i][0] = this.asm.symbols.get(objectArray[i]);
                }
                JTable jTable = new JTable(objectArray2, new Object[]{"Location", "Symbol"});
                jTable.setAutoCreateRowSorter(true);
                JScrollPane jScrollPane = new JScrollPane(jTable);
                jTable.setPreferredScrollableViewportSize(new Dimension(10, 90));
                StyledDocument styledDocument = this.jepMessages.getStyledDocument();
                Style style = styledDocument.addStyle("StyleName", null);
                StyleConstants.setComponent(style, jScrollPane);
                styledDocument.insertString(styledDocument.getLength(), "ignored text", style);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.machineSP.getVerticalScrollBar().setModel(this.codeSP.getVerticalScrollBar().getModel());
            this.mbsbMachineKnob.setColor(Color.green);
            this.machineTA.setBackground(Color.white);
        }
    }

    public void highlightCode(int n, Object object, Highlighter highlighter, Highlighter.HighlightPainter highlightPainter) {
        try {
            highlighter.addHighlight(10, 20, this.painterRed);
            highlighter.addHighlight(40, 60, this.painterChng);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Assembler.assemble execption: BadLocation");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jbDump) {
            this.dump();
        }
        if (actionEvent.getSource() == this.jbAssemble) {
            this.assemble();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.machineSP.getVerticalScrollBar().setModel(this.brmMachineSP);
        this.machineTA.setBackground(Color.yellow);
        this.mbsbMachineKnob.setColor(Color.yellow);
    }
}

