/*
 * Decompiled with CFR 0.152.
 */
class AssemblerInstruction {
    Assembler ass = null;
    String mnemonic = null;
    AssemblerFormat fmt = null;
    MyInteger code;

    public AssemblerInstruction(Assembler as, String[] tokens) {
        this.ass = as;
        this.mnemonic = tokens[0].trim();
        this.fmt = as.getAssemblerFormatByName(tokens[1].trim());
        this.code = new MyInteger(Integer.parseInt(tokens[2].trim(), 16));
    }

    public String getCode(int ws, MyInteger p1, MyInteger p2, MyInteger p3) {
        String sb = "";
        int v = this.code.i;
        if (p1 != null) {
            v |= p1.i;
        }
        if (p2 != null) {
            v |= p2.i;
        }
        if (p3 != null) {
            v |= p3.i;
        }
        switch (ws) {
            case 1: {
                if (this.fmt.length > 3) {
                    sb = sb + String.format("%02x ", v >>> 24 & 0xFF);
                }
                if (this.fmt.length > 2) {
                    sb = sb + String.format("%02x ", v >>> 16 & 0xFF);
                }
                if (this.fmt.length > 1) {
                    sb = sb + String.format("%02x ", v >>> 8 & 0xFF);
                }
                sb = sb + String.format("%02x", v & 0xFF);
                break;
            }
            case 2: {
                if (this.fmt.length > 1) {
                    sb = sb + String.format("%04x ", v >>> 16);
                }
                sb = sb + String.format("%04x", v & 0xFFFF);
                break;
            }
            case 4: {
                sb = sb + String.format("%08x", v);
            }
        }
        return sb;
    }

    public String toString() {
        String sb = "";
        sb = sb + this.mnemonic + ", ";
        sb = sb + this.fmt.name + ", ";
        sb = sb + this.code;
        return sb;
    }
}

