/*
 * Decompiled with CFR 0.152.
 */
import java.util.Scanner;
import javax.swing.JOptionPane;

class AssemblerFormat {
    String name;
    int length = 2;
    int fieldCount = 0;
    int[] fields = new int[8];
    AssemblerFormatFieldType f1type = AssemblerFormatFieldType.NONE;
    AssemblerFormatFieldType f2type = AssemblerFormatFieldType.NONE;
    AssemblerFormatFieldType f3type = AssemblerFormatFieldType.NONE;

    public AssemblerFormat(String[] tokens) {
        for (String t : tokens) {
            Scanner sc = new Scanner(t);
            String n = sc.next().trim();
            if (n.equals("name")) {
                this.name = sc.next().trim();
            }
            if (n.equals("words")) {
                this.length = sc.nextInt();
            }
            if (n.equals("fieldCount")) {
                this.fieldCount = sc.nextInt();
            }
            if (n.equals("codeBits")) {
                this.fields[0] = sc.nextInt();
                this.fields[1] = sc.nextInt();
            }
            if (n.equals("f1")) {
                this.fields[2] = sc.nextInt();
                this.fields[3] = sc.nextInt();
            }
            if (n.equals("f2")) {
                this.fields[4] = sc.nextInt();
                this.fields[5] = sc.nextInt();
            }
            if (!n.equals("f3")) continue;
            this.fields[6] = sc.nextInt();
            this.fields[7] = sc.nextInt();
        }
        this.sanityCheck();
    }

    private void sanityCheck() {
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] <= 31) continue;
            this.fields[i] = -1;
            JOptionPane.showMessageDialog(null, "AssemblerFormat.sanityCheck\nField sizes larger than 31 not currently supported");
        }
    }

    public String toString() {
        String sb = "";
        sb = sb + "format, name " + this.name;
        sb = sb + ", words " + this.length;
        sb = sb + ", fieldCount " + this.fieldCount;
        sb = sb + ", codeBits " + this.fields[0] + " " + this.fields[1];
        if (this.fields[2] != -1) {
            sb = sb + ", f1 " + this.fields[2];
        }
        if (this.fields[3] != -1) {
            sb = sb + " " + this.fields[3];
        }
        if (this.fields[4] != -1) {
            sb = sb + ", f2 " + this.fields[4];
        }
        if (this.fields[5] != -1) {
            sb = sb + " " + this.fields[5];
        }
        if (this.fields[6] != -1) {
            sb = sb + ", f3 " + this.fields[6];
        }
        if (this.fields[7] != -1) {
            sb = sb + " " + this.fields[7];
        }
        return sb;
    }
}

