/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class Assembler {
    static int[] masksB = new int[]{0, 255, 65535, 0xFFFFFF, -1};
    static int[] shiftB = new int[]{1, 256, 65536, 0x1000000};
    int wordSize = 1;
    ArrayList<AssemblerFormat> af = new ArrayList();
    ArrayList<AssemblerInstruction> aInstructions = new ArrayList();
    Hashtable<String, MyInteger> symbols;
    String messages = "No messages";
    boolean successfulFlag = true;

    public void clear() {
        this.af.clear();
        this.aInstructions.clear();
        if (this.symbols != null) {
            this.symbols.clear();
        }
        this.messages = "";
    }

    public boolean processLine(String st) {
        String stc;
        String[] tk;
        int commentLocator = st.indexOf(59);
        if (commentLocator == -1) {
            commentLocator = st.indexOf(47);
        }
        if (commentLocator == -1) {
            commentLocator = st.length();
        }
        if ((tk = (stc = st.substring(0, commentLocator)).split(",")).length == 0) {
            return true;
        }
        if (tk[0].trim().equals("word")) {
            this.wordSize = Integer.parseInt(tk[1].substring(6).trim());
        } else if (tk[0].trim().equals("format")) {
            this.af.add(new AssemblerFormat(tk));
        } else {
            this.aInstructions.add(new AssemblerInstruction(this, tk));
        }
        return true;
    }

    public AssemblerFormat getAssemblerFormatByName(String st) {
        for (AssemblerFormat f : this.af) {
            if (!f.name.equals(st)) continue;
            return f;
        }
        return null;
    }

    public AssemblerInstruction getAssemblerInstructionByName(String st, int fieldNum) {
        for (AssemblerInstruction f : this.aInstructions) {
            if (!f.mnemonic.equals(st) || f.fmt.fieldCount != fieldNum) continue;
            return f;
        }
        return null;
    }

    public void loadSymbols(String[] lines) {
        int location = 0;
        for (String line : lines) {
            String stc;
            String[] tokens;
            if (line.trim().length() == 0 || line.startsWith("/") || line.startsWith(";")) continue;
            int commentLocator = line.indexOf(59);
            if (commentLocator == -1) {
                commentLocator = line.indexOf(47);
            }
            if (commentLocator == -1) {
                commentLocator = line.length();
            }
            if ((tokens = (stc = line.substring(0, commentLocator)).split("[\\s,]+"))[0].length() > 0) {
                this.symbols.put(tokens[0], new MyInteger(location));
            }
            if (tokens[1].equals("SETPCSTART")) continue;
            if (tokens[1].equals("ORG")) {
                location = Integer.parseInt(tokens[2], 16);
                continue;
            }
            if (tokens[1].equals("DEC")) {
                ++location;
                continue;
            }
            if (tokens[1].equals("HEX")) {
                ++location;
                continue;
            }
            if (tokens[1].equals("CHR")) {
                ++location;
                continue;
            }
            if (tokens[1].equals("STR")) {
                location += this.getLocationString(stc);
                continue;
            }
            if (tokens[1].equals("END")) break;
            int tokenCount = tokens.length;
            AssemblerInstruction aInstruction = this.getAssemblerInstructionByName(tokens[1], tokenCount - 2);
            if (aInstruction == null) {
                JOptionPane.showMessageDialog(null, "Assembler.loadSymbols - cannot find instruction: \n" + line);
                this.messages = this.messages + "\nAssembler.loadSymbols - cannot find instruction: \n" + line;
                continue;
            }
            location += aInstruction.fmt.length;
        }
    }

    int getLocationString(String stc) {
        int val = 0;
        int start = stc.indexOf("\"") + 1;
        int end = stc.indexOf("\"", start);
        String st = stc.substring(start, end);
        val = (st.length() + this.wordSize - 1) / this.wordSize;
        return val;
    }

    int countChars(String stc) {
        int start = stc.indexOf("\"") + 1;
        int end = stc.indexOf("\"", start);
        return (end - start + this.wordSize - 1) / this.wordSize;
    }

    String processSTR(String stc) {
        String sb = "";
        int val = 0;
        int start = stc.indexOf("\"") + 1;
        int end = stc.indexOf("\"", start);
        String st = stc.substring(start, end);
        val = (st.length() + this.wordSize - 1) / this.wordSize;
        int position = this.wordSize - 1;
        int word = 0;
        char[] cArray = st.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            word += (c.charValue() & 0xFF) * shiftB[position--];
            if (position >= 0) continue;
            sb = sb + String.format(" %0" + 2 * this.wordSize + "x", word);
            position = this.wordSize - 1;
            word = 0;
        }
        if (word != 0) {
            sb = sb + String.format(" %0" + 2 * this.wordSize + "x", word);
        }
        sb = sb + "\n";
        return sb;
    }

    public String generateCode(String[] lines) {
        String sb = "";
        String pcStart = "";
        int location = 0;
        sb = sb + "loadRam";
        for (int i = 0; i < lines.length; ++i) {
            try {
                int v1;
                String stc;
                String[] tokens;
                if (lines[i].trim().length() == 0) {
                    sb = sb + "\n";
                    continue;
                }
                if (lines[i].startsWith("/")) {
                    sb = sb + "\n";
                    continue;
                }
                if (lines[i].startsWith(";")) {
                    sb = sb + "\n";
                    continue;
                }
                int commentLocator = lines[i].indexOf(59);
                if (commentLocator == -1) {
                    commentLocator = lines[i].indexOf(47);
                }
                if (commentLocator == -1) {
                    commentLocator = lines[i].length();
                }
                if ((tokens = (stc = lines[i].substring(0, commentLocator)).split("[\\s,]+"))[0].length() > 0) {
                    this.symbols.put(tokens[0], new MyInteger(location));
                }
                if (tokens[1].equals("SETPCSTART")) {
                    v1 = this.getValue((String)tokens[2]).i & masksB[this.wordSize];
                    sb = sb + "\n";
                    pcStart = String.format("%0" + 2 * this.wordSize + "x", v1);
                    continue;
                }
                if (tokens[1].equals("ORG")) {
                    location = Integer.parseInt(tokens[2], 16);
                    sb = sb + "\n";
                    if (!pcStart.equals("")) continue;
                    pcStart = tokens[2];
                    continue;
                }
                if (tokens[1].equals("DEC")) {
                    v1 = Integer.parseInt(tokens[2]) & masksB[this.wordSize];
                    sb = sb + String.format("%4x: %0" + 2 * this.wordSize + "x\n", location, v1);
                    ++location;
                    continue;
                }
                if (tokens[1].equals("HEX")) {
                    v1 = this.getValue((String)tokens[2]).i & masksB[this.wordSize];
                    sb = sb + String.format("%4x: %0" + 2 * this.wordSize + "x\n", location, v1);
                    ++location;
                    continue;
                }
                if (tokens[1].equals("CHR")) {
                    v1 = tokens[2].charAt(1);
                    sb = sb + String.format("%4x: %0" + 2 * this.wordSize + "x\n", location, v1);
                    ++location;
                    continue;
                }
                if (tokens[1].equals("STR")) {
                    sb = sb + String.format("%4x: ", location) + this.processSTR(stc);
                    location += this.countChars(stc);
                    continue;
                }
                if (tokens[1].equals("END")) break;
                int tokenCount = tokens.length;
                AssemblerInstruction asmInst = this.getAssemblerInstructionByName(tokens[1], tokenCount - 2);
                MyInteger p3 = null;
                MyInteger p2 = null;
                MyInteger p1 = null;
                if (tokenCount > 2) {
                    p1 = this.getValue(tokens[2]);
                }
                if (tokenCount > 3 && !"i".equalsIgnoreCase(tokens[3])) {
                    p2 = this.getValue(tokens[3]);
                }
                if (tokenCount > 4) {
                    p3 = this.getValue(tokens[4]);
                }
                sb = sb + String.format("%4x: %s - %4d\n", location, asmInst.getCode(this.wordSize, p1, p2, p3), i);
                location += asmInst.fmt.length;
                continue;
            }
            catch (Exception e) {
                this.messages = this.messages + "\nCode could not be generated for the following line:\n" + lines[i];
            }
        }
        sb = sb + "endLoadRam\n\n";
        sb = sb + "PCStart, PC, " + pcStart + "\n";
        return sb;
    }

    public MyInteger getValue(String st) {
        try {
            int v = Integer.parseInt(st, 16);
            return new MyInteger(v);
        }
        catch (Exception v) {
            MyInteger mi = this.symbols.get(st);
            if (mi == null) {
                this.messages = this.messages + "\nSymbol not found: " + st;
            }
            return mi;
        }
    }

    public String assemble(String sc) {
        this.messages = "";
        this.symbols = new Hashtable();
        String[] lines = sc.split("[\\r\\n]");
        this.loadSymbols(lines);
        String sb = this.generateCode(lines);
        if (this.messages.length() == 0) {
            this.messages = this.messages + "Assembly successful";
            this.successfulFlag = true;
        } else {
            this.messages = this.messages + "\n--- Assembly ERRORS! ---\n";
            this.successfulFlag = false;
        }
        return sb;
    }

    public String getMessages() {
        return this.messages.toString();
    }

    public String toStringSymbolTable() {
        String st = "Symbol Table:";
        for (String s : this.symbols.keySet()) {
            st = st + String.format("\n%4s = %s", this.symbols.get(s), s);
        }
        return st;
    }

    public String toString() {
        String sb = "";
        sb = sb + "\nassembler\n";
        sb = sb + "\nword, bytes " + this.wordSize + "\n";
        sb = sb + "\n// The formats:\n\n";
        for (AssemblerFormat assemblerFormat : this.af) {
            sb = sb + assemblerFormat + "\n";
        }
        sb = sb + "\n// The instructions:\n\n";
        for (AssemblerInstruction assemblerInstruction : this.aInstructions) {
            sb = sb + assemblerInstruction + "\n";
        }
        sb = sb + "\nendAssembler\n";
        return sb.toString();
    }
}

