/*
 * Decompiled with CFR 0.152.
 */
class ALU_Sub
extends ALUOperation {
    private RegisterFunctions R;
    private RegisterFunctions A;
    private RegisterFunctions B;
    private RegisterFunctions C;

    public ALU_Sub(ComputerInterface comp, String ... sa) {
        super(new RegisterFunctions[0]);
        if (sa.length < 3) {
            return;
        }
        this.R = comp.getRegisterByName(sa[0]);
        this.A = comp.getRegisterByName(sa[2]);
        this.B = comp.getRegisterByName(sa[4]);
        if (sa.length >= 6) {
            this.C = comp.getRegisterByName(sa[5]);
        }
        if (this.A == null || this.B == null || this.R == null) {
            return;
        }
        this.notOK = false;
    }

    @Override
    public void doOp() {
        int v = this.A.getValue() - this.B.getValue();
        if (this.C != null) {
            this.C.setValue(v >> this.A.getSize());
        }
        this.R.setValue(v &= ALUOperation.mask[this.A.getSize()]);
    }

    public String toString() {
        if (this.notOK) {
            return "\n\nALU_Sub operation: problem with registers\n" + this.R.getName() + " " + this.A.getName() + " " + this.B.getName() + "\n";
        }
        if (this.C == null) {
            return this.R.getName() + " < " + this.A.getName() + " ALU_Sub " + this.B.getName();
        }
        return this.R.getName() + " < " + this.A.getName() + " ALU_Sub " + this.B.getName() + " " + this.C.getName();
    }
}

