/*
 * Decompiled with CFR 0.152.
 */
class ALU_ShiftRightWithCarry
extends ALUOperation {
    private RegisterFunctions R;
    private RegisterFunctions A;
    private RegisterFunctions B;

    public ALU_ShiftRightWithCarry(ComputerInterface comp, String ... sa) {
        super(new RegisterFunctions[0]);
        this.setRegisters(comp.getRegisterByName(sa[0]), comp.getRegisterByName(sa[2]), comp.getRegisterByName(sa[4]));
    }

    private void setRegisters(RegisterFunctions ... rfa) {
        if (rfa.length < 3) {
            return;
        }
        this.R = rfa[0];
        this.A = rfa[1];
        this.B = rfa[2];
        if (this.A == null || this.B == null || this.R == null) {
            return;
        }
        this.notOK = false;
    }

    @Override
    public void doOp() {
        int a = this.A.getValue();
        int b = this.B.getValue() << this.A.getSize() - 1;
        int c = a & 1;
        int d = a >> 1 & ALUOperation.mask[this.A.getSize()];
        this.R.setValue(b + d);
        this.B.setValue(c);
    }

    public String toString() {
        if (this.notOK) {
            return "\n\nALU_ShiftRightWithCarry operation: problem with registers\n" + this.R.getName() + " " + this.A.getName() + " " + this.B.getName() + "\n";
        }
        return this.R.getName() + " < " + this.A.getName() + " ALU_ShiftRightWithCarry " + this.B.getName();
    }
}

