/*
 * Decompiled with CFR 0.152.
 */
class ALU_RegisterMove
extends ALUOperation {
    private RegisterFunctions R;
    private RegisterFunctions A;
    private ComputerInterface comp;
    private MoveDirection memoryDirection = MoveDirection.NONE;
    private int startS = -1;
    private int endS = -1;
    private int startT = -1;
    private int endT = -1;

    public ALU_RegisterMove(ComputerInterface ci, String ... sa) {
        super(new RegisterFunctions[0]);
        this.comp = ci;
        if (sa[0].equals("M")) {
            this.memoryDirection = MoveDirection.WRITE;
            this.setRegisters(this.comp.getRegisterByName(sa[1]), this.comp.getRegisterByName(sa[3]));
            this.notOK = false;
            return;
        }
        if (sa[0].equals("SimulatorOutput")) {
            this.memoryDirection = MoveDirection.OUTPUT;
            this.notOK = false;
        }
        if (sa[2].equals("M")) {
            this.memoryDirection = MoveDirection.READ;
            this.setRegisters(this.comp.getRegisterByName(sa[0]), this.comp.getRegisterByName(sa[3]));
            this.notOK = false;
            return;
        }
        if (sa[2].equals("SimulatorInput")) {
            this.memoryDirection = MoveDirection.INPUT;
            this.notOK = false;
        }
        int i = 0;
        RegisterFunctions rt = this.comp.getRegisterByName(sa[i]);
        try {
            this.startT = Integer.parseInt(sa[i + 1].trim());
            this.endT = Integer.parseInt(sa[i + 2].trim());
            if (this.startT > this.endT) {
                int tmp = this.startT;
                this.startT = this.endT;
                this.endT = tmp;
            }
            i += 2;
            this.notOK = false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.notOK = true;
        }
        catch (NumberFormatException e) {
            this.notOK = true;
        }
        if (this.notOK) {
            try {
                this.endT = this.startT = Integer.parseInt(sa[i + 1].trim());
                ++i;
                this.notOK = false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.notOK = true;
            }
            catch (NumberFormatException e) {
                this.notOK = true;
            }
        }
        RegisterFunctions rs = this.comp.getRegisterByName(sa[i += 2]);
        try {
            this.startS = Integer.parseInt(sa[i + 1].trim());
            this.endS = Integer.parseInt(sa[i + 2].trim());
            i += 2;
            this.notOK = false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.notOK = true;
        }
        catch (NumberFormatException e) {
            this.notOK = true;
        }
        if (this.notOK) {
            try {
                this.endS = this.startS = Integer.parseInt(sa[i + 1].trim());
                ++i;
                this.notOK = false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.notOK = true;
            }
            catch (NumberFormatException e) {
                this.notOK = true;
            }
        }
        if (++i != sa.length) {
            this.notOK = true;
        } else {
            this.setRegisters(rt, rs);
        }
    }

    private void setRegisters(RegisterFunctions x, RegisterFunctions y) {
        this.R = x;
        this.A = y;
        if (this.A == null || this.R == null) {
            return;
        }
        this.notOK = false;
    }

    @Override
    public void doOp() {
        int x = this.A.getValue();
        switch (this.memoryDirection) {
            case OUTPUT: {
                this.comp.setNewOutput(true);
            }
            case INPUT: 
            case NONE: {
                if (this.endS != -1) {
                    x = x >> this.startS & ALUOperation.mask[this.endS - this.startS + 1];
                }
                if (this.endT != -1) {
                    int m = ALUOperation.mask[this.endT - this.startT + 1];
                    int r = this.R.getValue() & ~m;
                    x = r + (x << this.startT);
                }
                this.R.setValue(x);
                break;
            }
            case READ: {
                this.R.setValue(this.comp.readMemory(this.A.getValue()));
                break;
            }
            case WRITE: {
                this.comp.writeMemory(this.R.getValue(), this.A.getValue());
            }
        }
    }

    public String toString() {
        if (this.notOK) {
            return "\n\nALU_RegisterMove operation: problem with registers\n" + this.R.getName() + " " + this.A.getName() + "\n";
        }
        String bitt = "";
        if (this.endT != -1) {
            bitt = " " + this.startT + " " + this.endT;
        } else if (this.startT != -1) {
            bitt = " " + this.startT;
        }
        String bits = "";
        if (this.endS != -1) {
            bits = " " + this.startS + " " + this.endS;
        } else if (this.startS != -1) {
            bits = " " + this.startS;
        }
        switch (this.memoryDirection) {
            case OUTPUT: 
            case INPUT: 
            case NONE: {
                return this.R.getName() + bitt + " < " + this.A.getName() + bits;
            }
            case READ: {
                return this.R.getName() + " < M " + this.A.getName();
            }
            case WRITE: {
                return " M " + this.R.getName() + " < " + this.A.getName();
            }
        }
        return "\n\nALU_RegisterMove operation: problem with registers, but was OK\n" + this.R.getName() + " " + this.A.getName() + "\n";
    }
}

