/*
 * Decompiled with CFR 0.152.
 */
class ALU_Complement
extends ALUOperation {
    private RegisterFunctions R;
    private RegisterFunctions A;

    public ALU_Complement(ComputerInterface comp, String ... sa) {
        super(new RegisterFunctions[0]);
        this.setRegisters(comp.getRegisterByName(sa[0]), comp.getRegisterByName(sa[2]));
    }

    private void setRegisters(RegisterFunctions ... rfa) {
        if (rfa.length < 2) {
            return;
        }
        this.R = rfa[0];
        this.A = rfa[1];
        if (this.A == null || this.R == null) {
            return;
        }
        this.notOK = false;
    }

    @Override
    public void doOp() {
        int v = this.A.getValue();
        v ^= 0xFFFFFFFF;
        this.R.setValue(v &= ALUOperation.mask[this.R.getSize()]);
    }

    public String toString() {
        if (this.notOK) {
            return "\n\nALU_Complement operation: problem with registers\n" + this.R.getName() + " " + this.A.getName() + "\n";
        }
        return this.R.getName() + " < " + this.A.getName() + " ALU_Complement";
    }
}

